/*
 * Main.java
 *
 * Created on 29 June 2006, 16:09
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package rfabroker;



import java.util.*;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.db.*;
import com.hp.hpl.jena.ontology.*;
import com.hp.hpl.jena.rdf.model.*;
import javax.swing.DefaultListModel;

/**
 *
 * @author Markos Fragkakis
 */
public class Broker {
    
    OntModelSpec mySpec;
    BrokerInterface myBrokerInterface;
    ModelMaker myModelMaker;
    OntModel currentModel;
    ExtendedIterator rfaProfileIterator, resProfileIterator, availableResourcesIterator, modelMakerModelsIterator;
    DefaultListModel matchesListModel;
    
    
    
    /** Creates a new instance of Broker */
    public Broker() {
        
        // Create the Swing Interface
        myBrokerInterface = new BrokerInterface( this );
        myBrokerInterface.setVisible(true);
        
        print("Initializing...\n");
        
        
        
        
        // ************* DATABASE CONNECTION *************
        
        print("Database Initialization...");
        
        String className = "com.mysql.jdbc.Driver";        // path of driver class
        try{
            Class.forName (className);                         // Load the Driver
        } catch (ClassNotFoundException ex1) {
            print("Could Not Establish Database Connection");
        }
        
        String DB_URL =    "jdbc:mysql://localhost/rfa";   // URL of database 
        String DB_USER =   "rfa";                          // database user id
        String DB_PASSWD = "rfa";                          // database password
        String DB =        "MySQL";                        // database type
        
        
        // Create database connection
        //IDBConnection conn = new DBConnection ( DB_URL, DB_USER, DB_PASSWD, DB );
        print(" OK!\n");
        

        

        
        
        
        
        
        // ************* JENA INITIALIZATION ************* 
        
        print("Jena Framework Initialization...");

        // Create Model Maker
        myModelMaker = ModelFactory.createMemModelMaker();
        // Create the specifications
        mySpec = new OntModelSpec( OntModelSpec.OWL_DL_MEM_RDFS_INF ); // No Inference  REMOVE LATER!!
        //mySpec = new OntModelSpec( OntModelSpec.OWL_DL_MEM_RULE_INF ); //With inference UNCOMMENT LATER!!
        mySpec.setImportModelMaker(myModelMaker);
        mySpec.setBaseModelMaker(myModelMaker);
        
        //Create the new KB
        Model baseModel1 = myModelMaker.createModel("newKB");			
        currentModel = ModelFactory.createOntologyModel(mySpec, baseModel1 );
        
        // Create a Document Manager ??????
        //OntDocumentManager myDocumentManager = new OntDocumentManager();
        //mySpec.setDocumentManager( myDocumentManager );       
        // set the mgr's properties now
        //... some code ...
        // now use it
        
        
        // Enable Interface Buttons
       myBrokerInterface.addResourceButton.setEnabled(true);
       
       print(" OK!\n");


        
        
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        // TODO code application logic here
        Broker myBroker = new Broker();
    }
    
    
    
    
    
    
    // ************* FUNCTIONAL METHODS ************* 
    
    public void addDocument(String documentURL) {
        Model newModel = myModelMaker.createModel(documentURL);
        
        OntModel newOntModel = ModelFactory.createOntologyModel(mySpec, newModel);        
        
        //newOntModel.begin();
        newOntModel.read(documentURL);
        //newOntModel.commit();
        
        //currentModel.begin();
        currentModel.addSubModel(newOntModel);
        //currentModel.commit();        
        
        print("Reading Resource document : " + documentURL + " OK! \n");
        
        refreshLoadedDocuments();
        refreshAvailableResources();
    }
    
    
    
    
    public void brokerRfa(String documentURL) {
        
        // Create a Default List Model (Netbeans did not create one...), fill it with information and display it.
        matchesListModel = new DefaultListModel();
       
        // Create a Model containing the RFA
        Model newModel = myModelMaker.createModel(documentURL);        
        OntModel newOntModel = ModelFactory.createOntologyModel(mySpec, newModel);
        newOntModel.read(documentURL);
        currentModel.addSubModel(newOntModel);
        
        // Get the RFA Profile...
        OntClass rfaProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#rfaProfile");        
        if(rfaProfileClass != null) {
            
            rfaProfileIterator = rfaProfileClass.listInstances();
            if(rfaProfileIterator.hasNext()) {
                // ... which means the first RFA you find. 
                //(TODO: MAKE THE SELECTION FROM THE JLIST OF THE GUI)
                Individual rfaProfile = (Individual) rfaProfileIterator.next();
                print("|-- Retrieved RFA Profile.\n");
                
                brokerRfaDirectly(rfaProfile);
                brokerRfaIndirectly(rfaProfile);
                
            } else {
                print("|-- There is no Profile Class in the loaded Documents!\n");
            }
        } else {
            print("|-- There is no Service Profile in the given URL\n");
        }      
    }
    
    
    
    void brokerRfaDirectly (Individual rfaProfile) {
        
        // This method will find direct matching between the RFA and the Resources, if any.
        // The matches will be added to the corresponding JList, in the Interface.
        
        // List all available resource Profiles
        OntClass resourceProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resProfile");
        if(resourceProfileClass != null) {

            print("|-- Checking available resources:\n");
            resProfileIterator = resourceProfileClass.listInstances();

            //For every one of the Profiles (available resources) returned ...
            int debugCount = 1;
            while(resProfileIterator.hasNext()) {
                
                Individual currentResProfile = (Individual) resProfileIterator.next();
                print("|---- Candidate # " + debugCount + ": " + currentResProfile.getLocalName() + "\n");
                Boolean checkResult = checkMatchOfProfiles(rfaProfile, currentResProfile);

                if (checkResult) {
                    matchesListModel.addElement(currentResProfile.getLocalName());
                }
                debugCount ++;

            }
            myBrokerInterface.matchesList.setModel(matchesListModel);
            myBrokerInterface.availableResourcesList.repaint();
        
        } else {
            print("|-- resourceProfileClass is null in the RFA Model\n");
        }
    }


    
    
    Boolean checkMatchOfProfiles(Individual rfaProfile, Individual resProfile) {

        // The two profiles will match if for every Input of the RFA there is one matching input in the Resource.
        // We will successively check all inputs, and only if there is a matching input for all of those, only then will this methid return true.
        
        Property hasInputProperty = currentModel.getProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        ExtendedIterator rfaHasInputValuesIterator = rfaProfile.listPropertyValues(hasInputProperty);
        while(rfaHasInputValuesIterator.hasNext()) {
            // Take the current Input and check if there is a matching Input in the resource Profile.
            RDFNode currentRfaInputNode = (RDFNode) rfaHasInputValuesIterator.next();
            Individual currentRfaInputIndividual = (Individual) currentRfaInputNode.as(Individual.class);
                        
            Boolean matchResourceInput = checkResourceForInput(currentRfaInputIndividual, resProfile);
            if (!matchResourceInput) {
                print("|---- Profile " + rfaProfile.getLocalName() + " does not match " + resProfile.getLocalName() + "\n");
                return false;
            }
        }
        print("|---- MATCH: " + rfaProfile.getLocalName() + " matches " + resProfile.getLocalName() + "\n");
        return true;
    }
    
    
    
    
    Boolean checkResourceForInput (Individual rfaInput, Individual resProfile) {
  
        // The method will succeed only if for rfaInput there is a matching input in the resProfile.
        // This will be checked by comparing successively all Inputs if the Profile to rfaInput.
        
        print("|------ RFA Input " + rfaInput.getLocalName() + " : Looking for equivalent...\n");
         
        Property hasInputProperty = currentModel.getProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        ExtendedIterator resHasInputValuesIterator = resProfile.listPropertyValues(hasInputProperty);
        while(resHasInputValuesIterator.hasNext()) {

            RDFNode currentResInputNode = (RDFNode) resHasInputValuesIterator.next();
            Individual currentResInputIndividual = (Individual) currentResInputNode.as(Individual.class);
            Boolean tempInputsMatch = checkMatchOfInputs(rfaInput, currentResInputIndividual);
            if(tempInputsMatch) {
                print("|------ RFA Input match : " + rfaInput.getLocalName() + " <-----> " + resProfile.getLocalName() + "\n");
                return true;
            }
        }
        print("|------ RFA Input " + rfaInput.getLocalName() + " : no match.\n");
        return false;
    }
    
    
    
    
    Boolean checkMatchOfInputs (Individual rfaInput, Individual resInput) {
        
        // This method will return true if the rfaInput and resInput match. That is if *ALL* the following are met:        
        // 1. They are of the same or subsumed type
        // 2. They contain the same Properties
        // 3. They have same or subsumed values in those Properties (Next method)
        
        OntClass rfaInputType = (OntClass) rfaInput.getRDFType(true).as(OntClass.class);
        OntClass resInputType = (OntClass) resInput.getRDFType(true).as(OntClass.class);
             
        // Check for point 1.
        // (If RFA and Res Inputs are of the same type)
        print("|-------- Resource Input candidate: " + resInput.getLocalName() + "\n");
        if (rfaInputType.hasSuperClass(resInputType)) {
            
            print("|---------- Type match : " + rfaInputType.getLocalName() +" <-----> " + resInputType.getLocalName() +"\n");
            
            // We need all properties, except the type ones.        
            ExtendedIterator rfaInputStatements = rfaInput.listProperties();
            OntProperty typeOntProperty = currentModel.getOntProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
            
            while (rfaInputStatements.hasNext()) {
                
                Statement rfaInputTempStatement = (Statement) rfaInputStatements.next();                
                OntProperty rfaInputTempProperty = (OntProperty) rfaInputTempStatement.getPredicate().as(OntProperty.class);
                if (!typeOntProperty.equals(rfaInputTempProperty)) {
                    if (resInput.hasProperty(rfaInputTempProperty)) {
                        Boolean checkResult = checkRfaPropertyValueAgainstResPropertyValue (rfaInput, rfaInputTempProperty, rfaInput.getPropertyValue(rfaInputTempProperty), resInput.getPropertyValue(rfaInputTempProperty));
                        if (!checkResult) {
                            return false; // Because some property had non matching Values
                        }
                    } else {
                        return false; // Because some property is not present in the Resource
                    }
                }
            }
            return true;
            
        } else {
            
            return false; // Because of non matching type of Inputs
        }       
    }
    
    
    
    Boolean checkRfaPropertyValueAgainstResPropertyValue (Individual rfaInput, OntProperty rfaInputTempProperty, RDFNode rfaInputPropertyValueNode, RDFNode resInputPropertyValueNode) {
        
        // This method will return true if the Values match.
        // Whether there is match or not is determined by the particular type of Input.
        
        //print("THE PROPERTY VALUES: " + rfaInputPropertyValueNode.toString() + " AND " + resInputPropertyValueNode.toString() + "\n");
        
        if(rfaInputPropertyValueNode.isLiteral() && resInputPropertyValueNode.isLiteral()) {
            // If they are literals, convert them to resources and then compare.
 
            print("|------------ Both Input Property Values are literals\n");
            
            Literal rfaInputPropertyValueLiteral = (Literal) rfaInputPropertyValueNode.as(Literal.class);
            Literal resInputPropertyValueLiteral = (Literal) resInputPropertyValueNode.as(Literal.class);
            
            OntClass boundInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#BoundInput");
            
            if (rfaInput.hasRDFType(boundInputOntClass)) {
                
                // If our Literals are Bound Literals, they need special comparison                
                Boolean checkResult = compareBoundLiterals(rfaInput, rfaInputTempProperty, rfaInputPropertyValueLiteral, resInputPropertyValueLiteral);
                return checkResult;
            } else {
                
                // else the InputPropertyValuesLiterals are actually URIs of Resources
                
                OntResource rfaInputPropertyValueLiteral2Resource = currentModel.getOntResource(rfaInputPropertyValueLiteral.getValue().toString());
                OntResource resInputPropertyValueLiteral2Resource = currentModel.getOntResource(resInputPropertyValueLiteral.getValue().toString());

                Boolean checkResult = compareOntResources (rfaInputTempProperty, rfaInputPropertyValueLiteral2Resource, resInputPropertyValueLiteral2Resource);
                return checkResult;
            }
            
            
        } else if (rfaInputPropertyValueNode.isResource() && resInputPropertyValueNode.isResource()) {
            // If they are resources, compare them.
        
            OntResource rfaInputPropertyValue = (OntResource) rfaInputPropertyValueNode.as(OntResource.class);
            OntResource resInputPropertyValue = (OntResource) resInputPropertyValueNode.as(OntResource.class);

            Boolean checkResult = compareOntResources (rfaInputTempProperty, rfaInputPropertyValue, resInputPropertyValue);
            return checkResult;
        } 
        
        // Else
        return false;
    }
    
    
    Boolean compareOntResources (OntProperty rfaInputProperty, OntResource firstResource, OntResource secondResource) {
        // This method compares two Ont Resources. It succeeds if:
        // 1. they are both the same Individual
        // 2. if they are both classes and the first is a suclass of the second
        // 3. If the first is an Individial, the second is a Class, and the Individual is an Instance of that Class.
        
        //print("THE RESOURCES: " + firstResource.toString() + " AND " + secondResource.toString() + "\n");
        
        if (firstResource.equals(secondResource)) {
            // Check for condition 1.
            
            print("|-------------- Input Property " + rfaInputProperty.getLocalName() + " : Value Match (" + firstResource.getLocalName() + ")\n");
            return true;
        } else if (firstResource.isClass() && secondResource.isClass()) {
            // Check for condition 2.

            OntClass firstResourceClass = (OntClass) firstResource.as(OntClass.class);
            OntClass secondResourceClass = (OntClass) firstResource.as(OntClass.class);

            if (firstResourceClass.hasSuperClass(secondResourceClass)) {
                print("|-------------- Input Property " + rfaInputProperty.getLocalName() + " : Value match (" + firstResourceClass.getLocalName() + ")\n");
                return true;
            }
        } else if (firstResource.isIndividual() && secondResource.isClass()){
            // Check for condition 3.

            Individual firstResourceIndividual = (Individual) firstResource.as(Individual.class);
            OntClass secondResourceClass = (OntClass) secondResource.as(OntClass.class);

            if (firstResourceIndividual.hasRDFType(secondResourceClass)) {
                print("|-------------- Input Property " + rfaInputProperty.getLocalName() + " : Value match (" + firstResourceIndividual.getLocalName() + ")\n");
                return true;
            }
            
        }
        print("|-------------- Input Property " + rfaInputProperty.getLocalName() + " : Value mismatch...\n");
        return false;
    }
    
    
    
    
    Boolean compareBoundLiterals (Individual rfaInput, OntProperty rfaInputProperty, Literal firstResource, Literal secondResource) {
    
        OntClass minimumboundInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#MinimumBoundInput");
        OntClass maximumboundInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#MaximumBoundInput");
          
        if ((rfaInput.hasRDFType(minimumboundInputOntClass)) && (firstResource.getInt() >= secondResource.getInt())) {

            print("|-------------- Input Property " + rfaInputProperty.getLocalName() + " : Value Match (" + firstResource.getInt() + " <= " + secondResource.getInt() + ")\n");
            return true;
        }
        if ((rfaInput.hasRDFType(maximumboundInputOntClass)) && (firstResource.getInt() <= secondResource.getInt())) {
            
            print("|-------------- Input Property " + rfaInputProperty.getLocalName() + " : Value Match (" + firstResource.getInt() + " >= " + secondResource.getInt() + ")\n");
            return true;
        }
        
        return false;
    }

    
    
    
    
    
    // ************* ORCHESTRATION METHODS METHODS ************* 
    
    
    void brokerRfaIndirectly (Individual rfaProfile) {
        
        // This method will find INdirect matching between the RFA and the Resources, if any.
        // The matches will be added to the corresponding JList, in the Interface.
        
        print("\n|-- Checking for Orchestrated solution.\n");
        
        
        OntClass rfaTransportProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#rfaTransportProfile");
        OntClass rfaProvideProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#rfaProvideProfile");
        OntClass resourceProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resProfile");
        
        //If this is an rfaTransportProfile
        if (rfaProfile.hasRDFType(rfaTransportProfileClass)) {
            
            print("\n|-- RFA is a Transport RFA.\n");
            
            Individual rfaDestinationLocationInput = getDestinationLocationInput(rfaProfile);
            print("\n|-- RFA Destination is " + rfaDestinationLocationInput.getLocalName() + "\n");
            
            // List all available resource Profiles
            print("|-- Checking available resources with matching destination: " + rfaDestinationLocationInput.getLocalName() + "\n");
            resProfileIterator = resourceProfileClass.listInstances();

            //For every one of the Profiles (available resources) returned ...
            int debugCount = 1;
            while(resProfileIterator.hasNext()) {
                
                Individual currentResProfile = (Individual) resProfileIterator.next();
                if (checkResourceForInput(rfaDestinationLocationInput, currentResProfile)) {
                    Individual resDestinationLocationInput = getDestinationLocationInput(currentResProfile);
                    print("|---- Candidate # " + debugCount + ": " + currentResProfile.getLocalName() + " has the same Destination: " + resDestinationLocationInput.getLocalName() + "\n");
                }
            }
        }
        
        
        //If this is an rfaTransportProfile
        if (rfaProfile.hasRDFType(rfaProvideProfileClass)) {
            
        }
    }
    
    
    
    Individual getDestinationLocationInput(Individual rfaProfile) {
                
        Property hasInputProperty = currentModel.getProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        OntClass LocationInputClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#InputLocation");
        ExtendedIterator rfaHasInputValuesIterator = rfaProfile.listPropertyValues(hasInputProperty);
        while(rfaHasInputValuesIterator.hasNext()) {

            RDFNode currentRfaInputNode = (RDFNode) rfaHasInputValuesIterator.next();
            Individual currentRfaInputIndividual = (Individual) currentRfaInputNode.as(Individual.class);
            
            if (currentRfaInputIndividual.hasRDFType(LocationInputClass)) {
                return currentRfaInputIndividual;
            }           
        }
        return null;
    }
    
    
    
    
    
    
    
    
    
    
    // ************* UPDATE GUI METHODS ************* 
        
    void refreshLoadedDocuments() {
        
        print("|-- Refreshing Loaded Documents List...");
        
        // Create a Default List Model (Netbeans did not create one...), fill it with information and display it.
        DefaultListModel tempModel1 = new DefaultListModel();

        //modelMakerModelsIterator = myModelMaker.listModels();
        
        modelMakerModelsIterator = currentModel.listClasses();
        
        while(modelMakerModelsIterator.hasNext()) {
            tempModel1.addElement( (String) modelMakerModelsIterator.next().toString());
        }
        myBrokerInterface.loadedDocumentsList.setModel(tempModel1);
        myBrokerInterface.loadedDocumentsList.repaint();
        
        print(" OK!\n");
    }
    
    
    
    void refreshAvailableResources() {
        
        print("|-- Refreshing Available Resources List...\n");
        
        // Create a Default List Model (Netbeans did not create one...), fill it with information and display it.
        DefaultListModel tempModel2 = new DefaultListModel();
        /*
        //DEBUG
        myExtendedIterator1 = currentModel.listClasses();
        while(myExtendedIterator1.hasNext()) {
            tempModel2.addElement( myExtendedIterator1.next());
        }
        tempModel2.addElement("NIAAAAA");
        myBrokerInterface.availableResourcesList.setModel(tempModel2);
        myBrokerInterface.availableResourcesList.repaint();
        //END - DEBUG 
       */
        
        print("|-- Getting Profile Class \n");
        OntClass resourceProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resProfile");
        print("|-- Checking if Profile class is inserted... \n");
        if(resourceProfileClass == null)
            print("|-- resourceProfileClass is null \n");
        else {
            print("|-- Listing Profile instances... ");
            //myExtendedIterator1 = currentModel.listClasses();
            availableResourcesIterator = resourceProfileClass.listInstances();
            while(availableResourcesIterator.hasNext()) {
                Individual tempAvailableResourceInstance = (Individual) availableResourcesIterator.next();
                tempModel2.addElement(tempAvailableResourceInstance.getLocalName());
            }
            myBrokerInterface.availableResourcesList.setModel(tempModel2);
            myBrokerInterface.availableResourcesList.repaint();
        }
        print("OK!\n");
        
    }
    
    
    
    public void print(String aString) {
        System.out.println(aString);
        myBrokerInterface.jTextArea2.append(aString);
        myBrokerInterface.jTextArea2.repaint();
    }
    
}
